                         
#|

(defun get-dos33-image ()
  (read-image (choose-file-dialog)))

(progn
  (setf *di* (read-image #P"Macintosh HD:Desktop Folder:sst folder:SST.DSK"))
  (setf *dir* (directory-image *di*) *foo* nil)
  (multiple-value-setq  (*sst* *sst-org*) 
    (binary-file-array *di* (read-directory-entry *dir* 1)))

;;; the portion of the file originally at $5000...$5FFF gets copied to D700..E6FF?
;;;       i.e. offsets 17664..21759
;;; the portion of the file originally at $4000...$4FFF gets copied to B000..BFFF?
;;;       i.e. offsets 13568..17663

;;; the jump labels get screwed up, unless I make the array larger, and put
;;; appropriate copies in these destinations.

  (let ((new-array (make-array 56320 :element-type 'unsigned-byte)))
    (loop for i from (- #xb00 #xb00) to (- #x5fff #xb00) 
          do 
          (setf (aref new-array i) (aref *sst* i)))
    (loop for i from 0 to #xfff
          do 
          (setf (aref new-array (+ i (- #xd700 #xb00)))
                (aref *sst* (+ (- #x5000 #xb00) i)))
          (setf (aref new-array (+ i (- #xb000 #xb00)))
                (aref *sst* (+ (- #x4000 #xb00) i))))
    
    (setf *sst-full* new-array *foo* nil)
    (setf *sst-labels* '(

                         ("WNDTOP" . #x22)
                         ("WNDBTM" . #x23)
                         ("CH" . #x24)
                         ("CV" . #x25)
                         
                         ("CSWL" . #x36)
                         ("CSWH" . #x37)

                         ("DRV0TRK" . #x0478)
                         ("DRV1TRK" . #x04F8)
                        
                         ("SLOT5F8" . #x05F8)

                     ("KBD" . #xC000)
                     ("KBDSTB" . #xC010)
                     ("SPKR" . #xC030)
                     ("TXTSET" . #xC051)
                     ("LOWSCR". #xC054) ; display text/gr page 1

                     ("C080Q0OFF" . #xC080)
                     ("C081Q0ON" . #xC081)
                     ("C082Q1OFF" . #xC082)
                     ("C083Q1ON" . #xC083)
                     ("C084Q2OFF" . #xC084)
                     ("C085Q2ON" . #xC085)
                     ("C086Q3OFF" . #xC086)
                     ("C087Q3ON" . #xC087)
                     ("C088MOTOFF" . #xC088)
                     ("C089MOTON" . #xC089)
                     ("C08ADRV1" . #xC08A)
                     ("C08BDRV2" . #xC08B)
                     
                     ("SLOT6Q6L" . #xC0EC)
                     ("C08CQ6L" . #xC08C)
                     ("C08DQ6H" . #xC08D)
                     ("C08ERDMODE" . #xC08E)
                     ("C08FWRMODE" . #xC08F)
                     
                     ("VTAB" . #xFC22)
                     ("HOME" . #xFC58)
                     ("COUT" . #xFDED)
                     ("SETKBD" . #xFE89)
                     ("SETVID". #xFE93)
                     ("RESET" . #xFF59)
                     ("DOSCOLD" . #x9D84)

                     ("PTR0" . #x00)
                     ("PTR0H" . #x01)

                     ("START" . #xB00)
                     ("LOAD50" . #XB02)
                     ("LOAD50+2" . #XB04)
                     ("DEST50" . #XB05)
                     ("DEST50+2" . #XB07)
                     ("LOAD40" . #XB08)
                     ("LOAD40+2" . #XB0A)
                     ("DEST40" . #XB0B)
                     ("DEST40+2" . #XB0D)

                     ("SAVEREG" . #X15CE)
                     ("RESTREG" . #X15E0)

                     ("L2036+1" . #x2037)

                     ("MSGTBL" . #x3000)
                     ("MSGTBL+1" . #x3001)

                     ("SVREGA" . #XB26E)
                     ("SVREGY" . #XB26F)
                     ("SVREGX" . #XB270)
                     ("SVREGP" . #XB271)))))

;; 1FB0-   CD B3 FB          CMP LFBB3
;; 2033-   AD B3 FB          LDA LFBB3

;; BBA1-   4C FF FF          JMP LFFFF
;; E0C2-   EE AE FF          INC LFFAE

;; 1FB9-   AD 17 C0          LDA LC017
;; 1FC9-   8D 03 C0          STA LC003
;; 1FCC-   8D 05 C0          STA LC005

;; 1FCF-   CD 00 0C          CMP L0C00

;; 1FF8-   8D 02 C0  L1FF8   STA LC002
;; 1FFB-   8D 04 C0          STA LC004




(disasm-apple  *sst-full* #xb00 '((:6502-code #xb00 #xb31)
                                  (:skip 2)
                                  (:hex #xb32 #xbff)
                                  (:skip 2)
                                  (:6502-code #xc00 #xc1f)
                                  (:skip 1)
                                  (:hex #xc20 #xc20)
                                  (:skip 1)
                                  (:6502-code #xc21 #x15cd)
                                  (:skip 2)
                                  (:6502-code #x15ce #x15df)
                                  (:skip 2)
                                  (:6502-code #x15e0 #x15ee)
                                  (:skip 2)
                                  (:6502-code #x15ef #x16b8)
                                  (:skip 1)
                                  (:screen-ascii #x16b9 #x16ce)
                                  (:skip 1)
                                  (:6502-code #x16cf #x17ff)
                                  (:6502-code #x1800 #x18ff)
                                  (:6502-code #x1901 #x1920)
                                  (:skip 1)
                                  (:hex #x1921 #x1928)
                                  (:skip 1)
                                  (:6502-code #x1929 #x1b06)
                                  (:skip 1)
                                  (:hex #x1b07 #x1b07)
                                  (:skip 1)
                                  (:6502-code #x1b08 #x1bd3) 
                                  (:skip 1)
                                  (:screen-ascii #x1bc9 #x1bd3)
                                  (:skip 1)
                                  (:6502-code #x1bd4 #x1bff)
                                  (:skip 2)
                                  (:screen-ascii #x1bfe #x1cff)
                                  (:6502-code #x1d00 #x1dff)
                                  (:6502-code #x1e01 #x1e4a)
                                  
                                  (:screen-ascii #x1e4b #x1eff)
                                  (:skip 2)
                                  (:6502-code #x1ef1 #x1f85)
                                  (:skip 2)
                                  (:screen-ascii #x1f86 #x1f91)
                                  (:skip 2)
                                  (:6502-code #x1f92 #x1fff)
                                  (:6502-code #x2001 #x2094)
                                  (:screen-ascii #x2095 #x20ff)
                                  (:6502-code #x2100 #x21ff)
                                  (:6502-code #x2200 #x22ff)
                                  (:6502-code #x2300 #x23ff)
                                  (:6502-code #x2400 #x2437)
                                  (:hex #x2438 #x247f)
                                  (:screen-ascii #x2480 #x24ff)
                                  (:screen-ascii #x2500 #x25ff)
                                  (:6502-code #x2600 #x26ff)
                                  (:6502-code #x2702 #x277b)
                                  (:screen-ascii #x277d #x2789)
                                  (:6502-code #x278a #x27ff)
                                  (:6502-code #x2801 #x28ff)
                                  (:6502-code #x2902 #x29ff)
                                  (:6502-code #x2a00 #x2aff)
                                  (:6502-code #x2b00 #x2bb9)
                                  (:hex #x2bba #x2bde)
                                  (:screen-ascii #x2bdf #x2bff)
                                  (:screen-ascii #x2c00 #x2c1b)
                                  (:6502-code #x2c1c #x2cff)
                                  (:6502-code #x2d00 #x2dff)
                                  (:6502-code #x2e00 #x2eff)
                                  (:6502-code #x2f00 #x2f26)
                                  (:hex #x2f27 #x2fff)
                                  (:skip 2)
                                  (:hex #x3000 #x3077) ; msgtbl
                                  (:skip 2)
                                  (:screen-ascii #x3078 #x30ff)
                                  (:screen-ascii #x3100 #x31ff)
                                  (:screen-ascii #x3200 #x32ff)
                                  (:screen-ascii #x3300 #x33ff)
                                  (:screen-ascii #x3400 #x34ff)
                                  (:screen-ascii #x3500 #x35ff)
                                  (:screen-ascii #x3600 #x36ff)
                                  (:screen-ascii #x3700 #x37ff)
                                  (:screen-ascii #x3800 #x38ff)
                                  (:screen-ascii #x3900 #x39ff)
                                  (:screen-ascii #x3a00 #x3aff)
                                  (:screen-ascii #x3b00 #x3bff)
                                  (:screen-ascii #x3c00 #x3cff)
                                  (:screen-ascii #x3d00 #x3dff)
                                  (:screen-ascii #x3e00 #x3eff)
                                  (:screen-ascii #x3f00 #x3f70)
                                  (:6502-code #x3f71 #x400f)
                                  (:hex #x4010 #x40ff)
                                  (:skip 5)
                                  (:hex #xb000 #xb0ff)
                                  (:hex #xb100 #xb1ff)
                                  (:hex #xb200 #xb2ff)
                                  (:hex #xb300 #xb3ff)
                                  (:hex #xb400 #xb4ff)
                                  (:6502-code #xb500 #xb56b)
                                  (:screen-ascii #xb56c #xb574)
                                  (:6502-code #xb575 #xb5d1)
                                  (:screen-ascii #xb5d2  #xb5e0)
                                  (:6502-code #xb5e1 #xb5ff)
                                  (:hex #xb600 #xb6ff)
                                  (:6502-code #xb700 #xb7ff)
                                  (:6502-code #xb800 #xb8ff)
                                  (:6502-code #xb900 #xb9ff)
                                  (:6502-code #xba02 #xbaff)
                                  (:6502-code #xbb02 #xbb61)
                                  (:hex #xbb62 #xbb73)
                                  (:6502-code #xbb74 #xbba8)
                                  (:screen-ascii #xbba4 #xbbd8)
                                  (:6502-code #xbbb0 #xbbff)
                                  (:6502-code #xbc00 #xbcff)
                                  (:6502-code #xbd00 #xbdff)
                                  (:6502-code #xbe00 #xbeff)
                                  (:6502-code #xbf00 #xbfe3)
                                  (:hex #xbfe3 #xbfff)
                                  (:6502-code #xd700 #xd7de)
                                  (:hex #xd7df #xd7ff)
                                  (:6502-code #xd800 #xd8ff)
                                  (:6502-code #xd901 #xd9ff)
                                  (:6502-code #xda00 #xda10)
                                  (:screen-ascii #xda11 #xda68)
                                  (:6502-code #xda69 #xda94)
                                  (:hex #xda95 #xdaff)
                                  (:hex #xdb00 #xdbff)
                                  (:hex #xdc00 #xdc55)
                                  (:6502-code #xdc56 #xdcff)
                                  (:6502-code #xdd00 #xddff)
                                  (:6502-code #xde00 #xdeff)
                                  (:6502-code #xdf01 #xdfa7)
                                  (:hex #xdfa8 #xdfc7)
                                  (:6502-code #xdfc8 #xdfff)
                                  (:6502-code #xe000 #xe089)
                                  (:screen-ascii #xe08a #xe0c4)
                                  (:6502-code #xe0bc #xe0ff)
                                  (:6502-code #xe102 #xe1ff)
                                  (:6502-code #xe201 #xe2ff)
                                  (:6502-code #xe300 #xe320)
                                  (:screen-ascii #xe321 #xe3ff)
                                  (:screen-ascii #xe400 #xe45e)
                                  (:6502-code #xe45b #xe47d)
                                  (:screen-ascii #xe47e #xe4af)
                                  (:6502-code #xe4b0 #xe4ff)
                                  (:6502-code #xe501 #xe5e5)
                                  (:screen-ascii #xe5e6 #xe5f7)
                                  (:6502-code #xe5f8 #xe604)
                                  (:screen-ascii #xe605 #xe654)
                                  (:6502-code #xe655 #xe666)
                                  (:screen-ascii #xe667 #xe6ff)
                                  ) *sst-labels*)


|#
              
#|
(setf *6502-label-table* (make-array  65536 :initial-element nil)
      
      (aref *6502-label-table* #xc000) "KEYBD"
      (aref *6502-label-table* #xc010) "KEYSTRB"
      (aref *6502-label-table* #xc030) "SPKR"
      (aref *6502-label-table* #xfded) "COUT"
      
      (aref *6502-label-table* #xb00) "START"
      (aref *6502-label-table* #xb02) "LOAD50"
      (aref *6502-label-table* #xb04) "LOAD50+2"
      (aref *6502-label-table* #xb05) "DEST50"
      (aref *6502-label-table* #xb07) "DEST50+2"
      (aref *6502-label-table* #xb08) "LOAD40"
      (aref *6502-label-table* #xb0a) "LOAD40+2"
      (aref *6502-label-table* #xb0b) "DEST40"
      (aref *6502-label-table* #xb0d) "DEST40+2"

      (aref *6502-label-table* #x15ce) "SAVEREG"
      (aref *6502-label-table* #x15E0) "RESTREG"

      (aref *6502-label-table* #xb26e) "SVREGA"
      (aref *6502-label-table* #xb26f) "SVREGY"
      (aref *6502-label-table* #xb270) "SVREGX"
      (aref *6502-label-table* #xb271) "SVREGP"

)

      
(with-open-file (str (choose-new-file-dialog :prompt "SST Full Disasm file") 
                     :direction :output)
    (symbol-6502-disasm *sst-full* '((0 50) (256 286) (289 3001) (3023 3617)
                                     (3625 4350) (4613 4939) (5105 5254) (5262 5525)
                                     (5632 6456) (6912 8378) (8476 9255) (13403 13568)
                                     
                                     ;;; $4000...
                                     ;; (14848 14956) (14965 15058) (15082 15104) 
                                     ;; (15360 16482) (16500 16555) (16560 16892)
                                     ;; (16900 17404) (17408 17636) 

                                     ;;; at $B000
                                     (43520 43628) (43637 43730) (43754 43776)
                                     (44032 45154) (45172 45227) (45232 45564)
                                     (45572 46076) (46080 46308)

                                     ;;; $5000...
                                     ;; (17664 17805)
                                     ;; (17811 17887) (17920 18449) (18537 18581) 
                                     ;; (19030 19880) (19912 20106) (20156 20769) 
                                     ;; (21085 21118) (21168 21478) (21589 21613) 
                                     ;; (21633 21664) (21684 21702) (21713 21759))
                        
                                     ;; at $d700
                                     (52224 52365)
                                     (52371 52447) (52480 53009) (53097 53141)
                                     (53590 54440) (54472 54666) (54716 55329)
                                     (55645 55678) (55728 56038) (56149 56173)
                                     (56193 56224) (56244 56262) (56273 56319))
                        *sst-org* *6502-label-table* str))

(disasm-apple-ascii *sst* 4350 4612 #xb00 nil)
(disasm-apple-ascii *sst* 4940 5104 #xb00 nil)
(disasm-apple-ascii *sst* 5525 5632 #xb00 nil)
(disasm-apple-ascii *sst* 6528 6911 #xb00 nil)
(disasm-apple-ascii *sst* 8415 8475 #xb00 nil)
(disasm-apple-ascii *sst* 9264 13442 #xb00 nil)

(with-open-file (str (choose-new-file-dialog :prompt "SST In-place dump file") 
                     :direction :output)
  (disasm-apple-ascii *sst* 0 13567 #xb00 nil str)
  (disasm-apple-ascii *sst* 13568 21759 #xb00 nil str)
  (disasm-apple-ascii *sst-full* 42240 46335 #xb00 nil str)
  (disasm-apple-ascii *sst-full* 52224 56319 #xb00 nil str))
  
|#